/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-30
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef STUDENTTESTCURVEMODEL_H
#define STUDENTTESTCURVEMODEL_H

#include "WinResults.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

  class MONOSTATION_EXPORT StudentTestCurveModel : public QAbstractItemModel
  {
  public:
    StudentTestCurveModel(QObject * parent=0);
    ~StudentTestCurveModel();

    void setWindowList(const QList<WinResults *>& l);

    virtual int rowCount(const QModelIndex& parent) const;
    virtual int columnCount(const QModelIndex&) const;
    virtual QVariant data(const QModelIndex& index, int role) const;
    virtual QModelIndex parent(const QModelIndex& index) const;
    virtual QModelIndex index (int row, int column, const QModelIndex& parent) const;
    virtual Qt::ItemFlags flags (const QModelIndex&) const;

    WinResults * winResults(const QModelIndex& index) const;
    AbstractStation * station(const QModelIndex& index) const;
    StationResults * stationResults(const QModelIndex& index) const;
  private:

    QList<WinResults *> _winList;
  };

} // namespace MonoStation

#endif // STUDENTTESTCURVEMODEL_H
