/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-09-23
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SUMMARYMAPOPTIONS_H
#define SUMMARYMAPOPTIONS_H

#include <SciFigs.h>
#include "ui_SummaryMapOptions.h"
#include "MonoStationDLLExport.h"
#include "AbstractSummary.h"

namespace MonoStation {

class MONOSTATION_EXPORT SummaryMapOptions : public QWidget, private Ui::SummaryMapOptions
{
  Q_OBJECT
public:
  SummaryMapOptions( QWidget * parent=0 );
  ~SummaryMapOptions();

  void setCategories( const Legend& c ) { _categories = c; }
  void setLabels( StationLine::Label l );
  void setValues( StationLine::ValueType v );
  void setPeakValueDecimals( int d );
  void setPeakIndex( int index );
  void setShowBubbles( bool b );

  const Legend& categories() const { return _categories; }
  StationLine::Label labels() const;
  StationLine::ValueType values() const;
  int peakValueDecimals() const;
  int peakIndex() const;
  bool showBubbles() const;
signals:
  void touched();
private slots:
  void on_peakNumber_toggled( bool checked );
  void on_categoryLegend_clicked();
  void on_labelPeakValue_toggled( bool checked );
  void commit();
private:
  Legend _categories;
  LegendProperties * _legendProperties;
};

} // namespace MonoStation

#endif // SUMMARYMAPOPTIONS_H
