/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-12-08
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WINRESULTS_H
#define WINRESULTS_H

#include <SciFigs.h>

#include "MonoStationDLLExport.h"

namespace MonoStation {

class AbstractStation;
class StationResults;
class PeakEditor;

class MONOSTATION_EXPORT WinResults : public GraphicSheetMenu
{
  Q_OBJECT
public:
  WinResults(QWidget *parent=0);

  virtual void addActions();
  virtual void setStations( QList<AbstractStation *> stations );
  virtual void setWindowTitle( QString subPoolName ) = 0;
  virtual void setLimits( double maxAmplitude );
  void restoreMakeUp(QString fileName);
  void setLayout(int nPlotsPerLine, double pageHeight);
  QMenu * menuTools;

  int stationCount() const {return _stations.count();}
  AbstractStation * station(int index) const {return _stations.at(index);}
  int indexOf(AbstractStation * c) {return _stations.indexOf(c);}
protected slots:
  void saveResults();
  virtual void loadResults() {}
  void options();
  void editPeaks();
  void setPeaks();
  void studentTest();
  void setCategories();
  void categoriesToGroups();
signals:
  void categoryChanged();
  void peakChanged();
protected:
  virtual void closeEvent (QCloseEvent * e);
  bool selectAll( QString title );
  void loadResults( QStringList fileNames );

  QString _yAxisTitle;
  QList<AbstractStation *> _stations;
};

} // namespace MonoStation

#endif // WINRESULTS_H
