/***************************************************************************
**
**  This file is part of MonoStation.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-10
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WINRESULTSOPTIONS_H
#define WINRESULTSOPTIONS_H

#include <QtGui>

#include "ui_WinResultsOptions.h"
#include "MonoStationDLLExport.h"

namespace MonoStation {

class StationResults;

class MONOSTATION_EXPORT WinResultsOptions : public QWidget, public Ui::WinResultsOptions
{
  Q_OBJECT
public:
  WinResultsOptions( QWidget* parent = 0, Qt::WFlags fl = 0 );

  void visibleLayers( const StationResults * sr ) const;
  void setVisibleLayers( const StationResults * sr );
  int visibleLayers() const;
  void setVisibleLayers( const int v );
private:
  QCheckBox * checkBox( int iLayer ) const;
  void setChecked( int ilayer, bool visible );
  bool isChecked( int ilayer ) const;
};

} // namespace MonoStation

#endif // WINRESULTSOPTIONS_H
