/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-05-22
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AUTOCORRREPORT_H
#define AUTOCORRREPORT_H

#include "QGpCompatibilityDLLExport.h"
#include "CompatInversionReport.h"

namespace QGpCompatibility {

class CompatAutocorrCurves;
class CompatAutocorrData;

class QGPCOMPATIBILITY_EXPORT CompatAutocorrReport :  public CompatInversionReport
{
public:
  /// Constructor: open file
  CompatAutocorrReport(bool isWrite, QString reportFile, QString naInFile=QString::null, int nModels=0);
  ~CompatAutocorrReport();
  /// Test whether this class is of type className
  virtual bool isA(const char * className);
  int  radiusCount();
  void addAutocorrGoal(CompatAutocorrData *ad);
  /**
     Re-writing over the existing goal curves, extrem caution may be observe to
     the size of the new CompatAutocorrData: it must be exactly the same structure as the
     one added with addAutocorrGoal(), only some changes in the values are tolerated
  */
  void modifyAutocorrGoal(CompatAutocorrData * rms);
  /// Add all block in one time with extension of autocorr curves
  void addModel(const LayeredModel * model, float * naModel,
                const CompatDispersion * disp,
                const CompatAutocorrCurves * ac,
                double cost, int modelID=-1);
  /// Add all block in one time with extension of autocorr curves
  void addModel(const LayeredModel * model, float * naModel,
                const CompatDispersion * disp,
                const CompatEllipticity * ell,
                const CompatAutocorrCurves * ac,
                double cost, int modelID=-1);
  /// load the autocorr curve only
  bool loadAutocorrOnly(int modelIndex);
  /// load the model, the cost, he dispersion curve and the autocorr curve
  bool loadAutocorr(int modelIndex);
  /// Same as above except that it loads the dispersion curve in a given dispersion object
  bool loadAutocorr(CompatAutocorrCurves * ac, int modelIndex);
  /// load the measured autocorr curves into a new autocorrData class
  CompatAutocorrData * loadAutocorrGoal();
  /// Returns the autocorr curves of current model
  CompatAutocorrCurves *  currentAutocorr();
protected:
  /// Last autocorr object loaded from stream
  CompatAutocorrCurves * _currentAutocorr;
  /// initialize current autocorrCurves object
  bool initCurrentAutocorr();
};

} // namespace QGpCompatibility

#include "CompatAutocorrCurves.h"

namespace QGpCompatibility {

inline CompatAutocorrCurves * CompatAutocorrReport::currentAutocorr()
{
  TRACE;
  if (!_currentAutocorr) loadAutocorr(0);  
  return _currentAutocorr;
}

inline int CompatAutocorrReport::radiusCount()
{
  TRACE;
  if (!_currentAutocorr) loadAutocorr(0);  
  return _currentAutocorr->radiusCount();
}
} // namespace QGpCompatibility

#endif // COMPATAUTOCORRREPORT_H
