/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-05-20
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATELLIPTICITYDATA_H
#define COMPATELLIPTICITYDATA_H

#include <QGpCoreWave.h>
#include "QGpCompatibilityDLLExport.h"
#include "CompatMultiModalData.h"
#include "CompatMultiModalCurves.h"

namespace QGpCompatibility {

#define CompatELLIPTICITY_INVALID_VALUE -999999

class CompatDispersion;

class QGPCOMPATIBILITY_EXPORT CompatEllipticity :  public CompatMultiModalCurves
{
public:
  /// Default constructor
  CompatEllipticity():
      CompatMultiModalCurves() {}
  /// Allocates an empty structure
  CompatEllipticity(int modesCount,int omegasCount):
      CompatMultiModalCurves(modesCount, omegasCount) {}
  /// Copy constructor
  CompatEllipticity(const CompatMultiModalFrequency *o):
      CompatMultiModalCurves(o) {}
  /// Copy constructor
  CompatEllipticity(const CompatMultiModalCurves *o):
      CompatMultiModalCurves(o) {}
  /// Copy constructor changing the number of modes
  CompatEllipticity(const CompatEllipticity * o,int modesCount):
      CompatMultiModalCurves(o, modesCount,CompatELLIPTICITY_INVALID_VALUE) {}
  /// Set all ellipticity curves to zero 
  void resetValues();
};

class QGPCOMPATIBILITY_EXPORT CompatEllipticityData :  public CompatEllipticity, public CompatMultiModalData
{
public:
  /// default constructor
  CompatEllipticityData();
  /// Allocates an empty structure
  CompatEllipticityData(int modesCount,int omegasCount);
  /// Allocates an empty structure based on an existing one with another number of modes
  CompatEllipticityData(const CompatEllipticityData * o,int modesCount);
  /// Set the values o as the measurements
  CompatEllipticityData(const CompatEllipticity * o);
  ///
  void valuesToData() {CompatMultiModalData::valuesToData(this);}
  /// Set the data fundamental frequency
  void setF0(double f0, double devf0) {_f0=f0; _devf0=devf0;}
  double f0() {return _f0;}
  double devf0() {return _devf0;}
  // I/O functions
  // -------------
  // Version 5 Store f0 in an inversion report
  void f0ToReport(QDataStream& s);
  // Version 5 Load f0 from an inversion report
  void reportToF0(QDataStream& s);
  // Compatibility with new framework
  ModalCurve curve( int iMode );
protected:
  double _f0;
  double _devf0;
};

} // namespace QGpCompatibility

#endif // COMPATELLIPTICITYDATA_H
