/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-06-10
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATFunctionList_H
#define COMPATFunctionList_H

#include "CompatFunction.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatFunctionList :  public QList<CompatFunction *>
{
public:
  CompatFunctionList();
  CompatFunctionList (const CompatFunctionList& o);
  ~CompatFunctionList();
  void deleteVectors();
  void clear();

  CompatFunctionList& operator=(const CompatFunctionList& o);

  int modesCount(bool multiMode, QString baseName, const QStringList& curveNames, int startAt);
  void addXSamples(CompatFunction& xModel, bool addInvalidY, double invalidValue);
  void sameSamplingForCurves(CompatFunction& xModel,bool interpole, double invalidValue);
  void inverseX();
  void average(int iMode,int i, double& average, double& averageStddev,
               int& hitsCount, double invalidValue, bool logStat);
  int cleanupAverage();
protected:
  // For resampling of multi mode ensemble of curves, list of selected curves by mode
  QList< QList<CompatFunction *> * > * _selected;
};

} // namespace QGpCompatibility

#endif // COMPATFUNCTIONLIST_H
