/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-09-17
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATHODOCHRONE_H
#define COMPATHODOCHRONE_H

#include "CompatMultiModalCurves.h"

namespace QGpCompatibility {

#define CompatHODOCHRONE_INVALID_VALUE -1

class CompatSubSignalPool;

class CompatHodoChrone :  public CompatMultiModalCurves
{
public:
  /// Default constructor
  CompatHodoChrone();
  /// Allocates an empty structure
  CompatHodoChrone(int modesCount,int omegasCount);
  /// Copy constructor
  CompatHodoChrone(const CompatMultiModalFrequency *o);
  /// Copy constructor changing the number of modes
  CompatHodoChrone(const CompatMultiModalFrequency *o,int modesCount);
  /// Copy constructor
  CompatHodoChrone(const CompatMultiModalCurves *o);
  /// Copy constructor changing the number of modes
  CompatHodoChrone(const CompatMultiModalCurves * o,int modesCount);
};

inline CompatHodoChrone::CompatHodoChrone(): CompatMultiModalCurves()
{
  TRACE;
  _freq2omega=1.0;
}

inline CompatHodoChrone::CompatHodoChrone(int modesCount,int omegasCount)
  : CompatMultiModalCurves(modesCount, omegasCount)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalFrequency *o)
  : CompatMultiModalCurves(o)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalFrequency *o,int modesCount)
  : CompatMultiModalCurves(o, modesCount)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalCurves *o)
  : CompatMultiModalCurves(o)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalCurves * o,int modesCount)
  : CompatMultiModalCurves(o, modesCount, CompatHODOCHRONE_INVALID_VALUE)
{
  TRACE;
  _freq2omega=1.0;  
}

} // namespace QGpCompatibility

#endif // COMPATHODOCHRONE_H
