/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-10-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALFREQUENCY_H
#define COMPATMODALFREQUENCY_H

#include <QGpCoreTools.h>
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatModalFrequency: public QVector<double>, public XMLClass
{
  TRANSLATIONS( "CompatModalFrequency" );
public:
  CompatModalFrequency();
  virtual ~CompatModalFrequency() {};

  virtual const QString& xml_tagName() const { return xmlModalFrequencyTag;}
  static const QString xmlModalFrequencyTag;

  void operator=( CompatModalFrequency& o );

  virtual void setNModes( int nm ) = 0;
  void setNRayleighModes( int nRm ) {_nRayleighModes = nRm;}
  virtual void setNOmegas( int nf ) {resize( nf );}

  virtual int nModes() const = 0;
  int nRayleighModes() const { return _nRayleighModes;}
  int nLoveModes() const { return nModes()-_nRayleighModes;}
  int nOmegas() const { return count();}

  void insertOmegas(const CompatModalFrequency& samples);
  virtual void addRayleighModes(int nNewModes) = 0;
  void addLoveModes(int nNewModes);

  double& omega( int iOmega ) { return operator[] ( iOmega );}
  const double& omega( int iOmega ) const { return operator[] ( iOmega );}

  void setFrequencies( QVector<double>& values );
  QVector<double> * frequencies() const;
  bool isSameOmegas( const CompatModalFrequency& o ) const;
protected:
  int _nRayleighModes;
protected:
  virtual void insertInvalidAt(int i) = 0;
  virtual void addInvalid() = 0;

  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
};

QGPCOMPATIBILITY_EXPORT QDataStream& operator<< ( QDataStream& s, const CompatModalFrequency& p );
QGPCOMPATIBILITY_EXPORT QDataStream& operator>> ( QDataStream& s, CompatModalFrequency& p );

} // namespace QGpCompatibility

#endif // COMPATMODALFREQUENCY_H
