/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-10-22
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALREFINE_H
#define COMPATMODALREFINE_H

#include <QtCore>
#include <QGpCoreTools.h>

namespace QGpCompatibility {

class CompatModalRefine
{
public:
  CompatModalRefine(double omega, double val);
  CompatModalRefine(int nm) {_values.resize(nm);}
  ~CompatModalRefine() {}
  
  bool operator<(const CompatModalRefine& o) const;
  
  double& omega() {return _omega;}
  const double& omega() const {return _omega;}
  
  double& value(int im) {return _values[im];}
  const double& value(int im) const {return _values[im];}
private:
  double _omega;
  QVector<double> _values;
};

inline bool CompatModalRefine::operator<(const CompatModalRefine& o) const
{
  TRACE;
  return _omega<o._omega;
}


} // namespace QGpCompatibility

#endif // COMPATMODALREFINE_H
