/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-10-22
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALREFINEDCURVES_H
#define COMPATMODALREFINEDCURVES_H

#include "CompatModalCurves.h"
#include "CompatModalRefine.h"
#include "CompatModalFrequency.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

typedef QList<CompatModalRefine> CompatRefineList;
typedef QList<CompatModalRefine>::iterator CompatRefineIterator;
typedef QList<CompatModalRefine>::const_iterator CompatRefineConstIterator;

class QGPCOMPATIBILITY_EXPORT CompatModalRefinedCurves : public CompatModalFrequency
{
public:
  void operator=( CompatModalRefinedCurves& o );

  void setNOmegas( int nf );
  virtual void setNModes( int nm ) {_curves.setNModes( nm );}
  int nModes() const { return _curves.nModes();}

  // Access to curves
  CompatVDataPointVector& mode( int im ) { return _curves.mode( im );}
  const CompatVDataPointVector& mode( int im ) const { return _curves.mode( im );}

  // Output
  QVector<double> * meanVector( int im ) { return _curves.meanVector( im );}
  QVector<double> * stddevVector( int im ) { return _curves.stddevVector( im );}
  QVector<double> * weightVector( int im ) { return _curves.weightVector( im );}
  int toPointVector( int imode, Point2D *& pointList );
  QVector<Point> * toPointVector( int imode );
  void toStream( FILE *f );

  virtual void addRayleighModes( int nNewModes );
  void addInvalidSamples( CompatModalFrequency * samples );

  void clearRefines() {_refines.clear();}
  int nRefines() const { return _refines.size();}
  void refineSort() {qSort( _refines );}

  void writeReport( QDataStream& s ) const;
protected:
  CompatModalCurves _curves;
  CompatRefineList _refines;
protected:
  virtual void insertInvalidAt( int i ) {_curves.insertInvalidAt( i );}
  virtual void addInvalid() {_curves.addInvalid();}
  virtual const QString& xml_tagName() const { return xmlModalRefinedCurvesTag;}
  static const QString xmlModalRefinedCurvesTag;
  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
};

inline void CompatModalRefinedCurves::setNOmegas( int nf )
{
  TRACE;
  CompatModalFrequency::setNOmegas( nf );
  _curves.setNOmegas( nf );
}

} // namespace QGpCompatibility

#endif // COMPATMODALREFINEDCURVES_H
