/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-05-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIMODALFREQUENCY_H
#define MULTIMODALFREQUENCY_H

#include <math.h>
#include <QGpCoreTools.h>
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatMultiModalFrequency
{
public:
  /// Default constructor
  CompatMultiModalFrequency();
  /// Constructor
  CompatMultiModalFrequency(int modesCount, int omegasCount);
  /// Copy constructor
  CompatMultiModalFrequency(const CompatMultiModalFrequency * o);
  /// Copy constructor changing the number of modes
  CompatMultiModalFrequency(const CompatMultiModalFrequency * o,int modesCount);
  /// Destructor: get rid of all unused memory
  virtual ~CompatMultiModalFrequency();
  
  //virtual const QString& xml_tagName() const {return xmlMultiModalFrequencyTag;}  
  //static const QString xmlMultiModalFrequencyTag;
  
  /// Copmpares two objects
  bool isSameOmegas(const CompatMultiModalFrequency * o) const;
  /// Prints the _omegas to the binary stream (usually the inversion_report)
  void omegaToReport(QDataStream& s) const;
  /// Loads the _omega from the binary stream (usually the inversion_report)
  void reportToOmega(QDataStream& s);
  /// Returns the omega count
  int omegasCount () const { return _omegasCount;}
  /// Returns the omega count
  int modesCount () const { return _modesCount;}
  /// Returns the periods
  QVector<double> * periods();
  /// Returns the frequencies
  QVector<double> * frequencies();
  /** 
      The list of omegas is generated from a QVector filled in by frequencies
      The easiest way is to create a CompatFunction and call this function passing
      a pointer to x() as parameter. Don't forget to use inverse() if necessary,
      make sure you pass a frequency vector as argument to this function.
      the number of values must be equal to _omegasCount
  */
  void setFrequencies(QVector<double> * values);
  /** 
      The list of omegas is generated from a QVector filled in by periods
      The easiest way is to create a CompatFunction and call this function passing
      a pointer to x() as parameter. Don't forget to use inverse() if necessary,
      make sure you pass a period vector as argument to this function.
      the number of values must be equal to _omegasCount
  */
  void setPeriods(QVector<double> * values);
  /// Returns the ith omega
  double omega(int i) const { return _omegas[i];}
  void setFrequency(int i, double f) { _omegas[i]=_freq2omega*f;}
protected:
  friend class CompatMultiModalData;
  /// Number of omegas where to calculate the dispersion
  int _omegasCount;
  /// Storage for omegas where to calculate the dispersion
  double * _omegas;
  /** Conversion factor from frequency to omega, this structure has been
    original developped for storing frequency dependent modal curves,
    currently extended to any collection of curves with common sample set */
  double _freq2omega;
  /// Number of modes
  int _modesCount;
/*protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(CompatStringSection&, CompatStringSection&);*/
};

} // namespace QGpCompatibility

#endif // COMPATMULTIMODALFREQUENCY_H
