/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-09-20
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATREFRAREPORT_H
#define COMPATREFRAREPORT_H

#include <QGpCoreWave.h>

#include "CompatInversionReport.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class CompatHodoChrone;
class CompatHodoChroneData;

class QGPCOMPATIBILITY_EXPORT CompatRefraReport :  public CompatInversionReport
{
public:
  CompatRefraReport(bool isWrite, QString reportFile, QString naInFile=QString::null, int nModels=0);
  ~CompatRefraReport();
  /// Test whether this class is of type className
  virtual bool isA(const char * className);
  void addRefraGoal(CompatHodoChroneData *hd);
  /**
     Re-writing over the existing goal curves, extrem caution may be observe to
     the size of the new CompatHodoChroneData: it must be exactly the same structure as the
     one added with addRefraGoal(), only some changes in the values are tolerated
  */
  void modifyRefraGoal(CompatHodoChroneData * rms);
  CompatHodoChroneData * loadRefraGoal();
  /// load the model, the cost, the hodochrone curve
  void loadRefra(int modelIndex);
  void loadRefra(CompatHodoChrone * hodo,int modelIndex);
  /// Returns the autocorr curves of current model
  CompatHodoChrone * currentHodoChrone();
  TiltLayeredModel * currentTiltModel();
protected:
  TiltLayeredModel * _currentTiltModel;
  void initCurrentTiltModel();
  /// initialize current dispersion object
  virtual bool initCurrentDispersion();
};

inline CompatHodoChrone * CompatRefraReport::currentHodoChrone()
{
  TRACE;
  if (!_currentDispersion) loadRefra(0);  
  return (CompatHodoChrone *)_currentDispersion;
}

inline TiltLayeredModel * CompatRefraReport::currentTiltModel()
{
  TRACE;
  if (!_currentTiltModel) initCurrentTiltModel();  
  return _currentTiltModel;
}

} // namespace QGpCompatibility

#endif // COMPATREFRAREPORT_H
