/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTFUNCTION2_H
#define ABSTRACTFUNCTION2_H

#include <QtCore>

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT AbstractFunction2
{
public:
  AbstractFunction2() {}
  virtual ~AbstractFunction2() {}

  virtual double value(double x, double y) const=0;
  virtual double value(double x, double y, int index) const { Q_UNUSED(index); return value(x, y); }
  virtual void initGrid(int n) { Q_UNUSED(n); }
  virtual void initGrid(double x, double y, int index) { Q_UNUSED(x); Q_UNUSED(y); Q_UNUSED(index); }
};

} // namespace QGpCoreTools

#endif // ABSTRACTFUNCTION2.H
