/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-04-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTNUMERICALCACHE_H
#define ABSTRACTNUMERICALCACHE_H

#include "QGpCoreToolsDLLExport.h"
#include "Global.h"
#include "CacheItem.h"
#include "AbstractNumericalKey.h"

namespace QGpCoreTools {

class HashNumericalKey;

class QGPCORETOOLS_EXPORT AbstractNumericalCache
{
public:
  inline AbstractNumericalCache( AbstractNumericalKey * key );
  virtual ~AbstractNumericalCache() { delete _key; }

  virtual void init() = 0;
  const AbstractNumericalKey& key() const { return *_key; }

  static const AbstractNumericalCache * begin( AbstractNumericalKey * key );
  static void end( const AbstractNumericalCache * cache );
  static void clear();
private:
  static AbstractNumericalCache * add( AbstractNumericalKey * key );

  clock_t lastUse() const { return _lastUse; }
  void use() const { _lastUse = clock(); }

  inline void setLocked( bool l ) const;
  bool locked() const { return !_locked.testAndSetOrdered(0, 0); }

  AbstractNumericalKey * _key;
  mutable clock_t _lastUse;
  mutable QAtomicInt _locked;

  static QMutex _mutex;
  static QHash<HashNumericalKey, AbstractNumericalCache *> _caches;
  static int _currentByteCount;
  static int _maximumByteCount;
};

inline AbstractNumericalCache::AbstractNumericalCache( AbstractNumericalKey * key )
{
  _key = key;
  _lastUse = clock();
  _locked = 0;
}

inline void AbstractNumericalCache::setLocked( bool l ) const
{
  if ( l ) {
    _locked.fetchAndAddOrdered ( 1 );
  } else {
    ASSERT( _locked.fetchAndAddOrdered ( -1 )>=0 );
  }
}

} // namespace QGpCoreTools

#endif // ABSTRACTNUMERICALCACHE_H
