/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-05-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef Circle_H
#define Circle_H


#include "Point2D.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT Circle
{
public:
  Circle(double x0,double y0, double r);
  virtual ~Circle() {}

  QVector<Point2D> intersect( const Circle& o );
  Point2D intersect( const Circle& o, bool& ok, const Circle& disc );
  double distanceTo( const Point2D& p ) const;
private:
  double _x0,_y0,_r;
};

} // namespace QGpCoreTools

#endif // CIRCLE_H
