/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-15
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXMATRIX_H
#define COMPLEXMATRIX_H

#include "Matrix.h"
#include "MatrixIterator.h"
#include "Complex.h"
#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT ComplexMatrix: public Matrix<Complex>
{
public:
  ComplexMatrix() : Matrix<Complex>() {}
  ComplexMatrix( int ndim ) : Matrix<Complex>( ndim, ndim ) {}
  ComplexMatrix( int nrow, int ncol ) : Matrix<Complex>( nrow, ncol ) {}
  ComplexMatrix( const Matrix<Complex> m ) : Matrix<Complex>( m ) {}
  ComplexMatrix( const ComplexMatrix& m ) : Matrix<Complex>( m ) {}

  inline ComplexMatrix conjugate() const;
};

inline ComplexMatrix ComplexMatrix::conjugate() const
{
  ComplexMatrix r(rowCount(),columnCount());
  MatrixIterator<Complex> itThis(*this);
  MutableMatrixIterator<Complex> itR(r);
  while(itThis.hasNext()) {
    itThis.next();
    itR.next();
    *itR = QGpCoreTools::conjugate(*itThis);
  }
  return r;
}

QGPCORETOOLS_EXPORT QTextStream& operator<<( QTextStream& s, const ComplexMatrix& m );

} // namespace QGpCoreTools

#endif // COMPLEXMATRIX_H
