/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DIRECTIONALSEARCH_H
#define DIRECTIONALSEARCH_H

#include "QGpCoreToolsDLLExport.h"
#include "Function2Search.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT DirectionalSearch : public Function2Search
{
public:
  DirectionalSearch();
  ~DirectionalSearch();

  void setAzimuth( double azimuth );
  void setGrid(double minR, double maxR, double dR);
  void setFunction( AbstractFunction2 * f ) { _function = f; }

  double globalMax();
  Function2MaximaIterator localMax(int nMax, double absThres=0.0, double relThres=0.0);
  void setRelativePrecision(double p) {_precision=p; _relative = true; }
  void setAbsolutePrecision(double p) {_precision=p; _relative = false; }

  double value( double r ) const { return _function->value( _cx*r, _sy*r ); }
protected:
  double _cx, _sy;
  int _nr;
  double * _r;
  double _precision;
private:
  double refineMax(double minR, double maxR);
  inline void checkForMax(double r, double& maxVal, double& maxR);
};

} // namespace QGpCoreTools

#endif // DIRECTIONALSEARCH_H
