/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-15
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DOUBLEMATRIX_H
#define DOUBLEMATRIX_H

#include "QGpCoreToolsDLLExport.h"
#include "AbstractStream.h"
#include "Matrix.h"
#include "MatrixIterator.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT DoubleMatrix: public Matrix<double>
{
public:
  DoubleMatrix() : Matrix<double>() {}
  DoubleMatrix( int ndim ) : Matrix<double>( ndim ) {}
  DoubleMatrix( int nrow, int ncol ) : Matrix<double>( nrow, ncol ) {}
  DoubleMatrix( const Matrix<double> m ) : Matrix<double>( m ) {}
  DoubleMatrix( const DoubleMatrix& m ) : Matrix<double>( m ) {}
};

QGPCORETOOLS_EXPORT AbstractStream& operator<<(AbstractStream& s, const DoubleMatrix& m);

class QGPCORETOOLS_EXPORT Matrix3x3: public DoubleMatrix
{
public:
  Matrix3x3() : DoubleMatrix( 3, 3 ) {}
  Matrix3x3( const Matrix3x3& o) : DoubleMatrix( static_cast<const DoubleMatrix&>(o) ) {}

  enum Axis {XAxis, YAxis, ZAxis};
  void rotation( Axis ax, double angle );

  inline Point operator*( const Point& p ) const;
};

inline Point Matrix3x3::operator*( const Point& p ) const
{
  TRACE;
  Point rp;
  const double * values = _d->values();
  rp.setX(values[0]*p.x()+values[3]*p.y()+values[6]*p.z());
  rp.setY(values[1]*p.x()+values[4]*p.y()+values[7]*p.z());
  rp.setZ(values[2]*p.x()+values[5]*p.y()+values[8]*p.z());
  return rp;
}

} // namespace QGpCoreTools

#endif // DOUBLEMATRIX_H
