/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FUNCTIONSEARCH_H
#define FUNCTIONSEARCH_H

#include "QGpCoreToolsDLLExport.h"
#include "AbstractFunction2.h"
#include "Trace.h"
#include "Point2D.h"

namespace QGpCoreTools {

class Function2SearchMaximum
{
public:
  Function2SearchMaximum(double value, const Point2D& pos) {
    _value=value;
    _pos=pos;
  }
  ~Function2SearchMaximum() {}

  bool operator<(const Function2SearchMaximum& o) const {return _value>o._value;}
  double value() const {return _value;}
  const Point2D& pos() const { return _pos; }
private:
  double _value;
  Point2D _pos;
};

typedef QList<Function2SearchMaximum>::iterator Function2MaximaIterator;

class QGPCORETOOLS_EXPORT Function2Search
{
public:
  Function2Search();
  ~Function2Search();

  void setFunction( AbstractFunction2 * f );
  AbstractFunction2 * takeFunction();

  double value(double x, double y) const { return _function->value(x,y); }
  double value(double x, double y, int index) const { return _function->value(x,y, index); }

  const Point2D& pos() const { return _pos; }
  Function2MaximaIterator localMax(int nMax, double absThres=0.0, double relThres=0.0);
  Function2MaximaIterator localMaxEnd() {return _localMaxima.end();}
protected:
  static inline double lowLimit(int i, double * axis);
  static inline double highLimit(int i, double * axis, int nAxis);

  Point2D _pos;
  AbstractFunction2 * _function;
  bool _relative;
  QList<Function2SearchMaximum> _localMaxima;
};

inline double Function2Search::lowLimit(int i, double * axis)
{
  TRACE;
  return i>0 ? axis[i-1] : axis[0];
}

inline double Function2Search::highLimit(int i, double * axis, int nAxis)
{
  TRACE;
  return i<nAxis-1 ? axis[i+1] : axis[nAxis-1];
}

} // namespace QGpCoreTools

#endif // FUNCTION2SEARCH.H
