/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-10-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GaussDistribution_H
#define GaussDistribution_H

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT GaussDistribution
{
 public:
  /**
     precision is the maximum tolerated difference accepted for probabilities
     mean and sigma are set to 0
  */
  GaussDistribution(double precision=1e-4);
  /**
     Initialize the distribution by its basic parameters:
     mean or x0
     stddev or sigma
     precision is the maximum tolerated difference accepted for probabilities
  */
  GaussDistribution(double mean, double stddev,double precision=1e-4);
  ///
  ~GaussDistribution(); 
  /**
     Return the probability of interval [a,b]
     calculate the integral from -inf to a and from -inf to b
  */
  double prob(double a, double b) {
    return (_calcErrorFunction((b-_mean)*_inv_stddev)
            -_calcErrorFunction((a-_mean)*_inv_stddev));
  }
  /// calculate the integral from -inf to a
  double part(double a) {
    return _calcErrorFunction((a-_mean)*_inv_stddev);
  }
  /// calculate the integral from -inf to mean+a*stddev
  double partSigma(double a) {return _calcErrorFunction(a);}
  /// returns the density of probability for value val
  double rho(double val);
  void setMean(double m) {_mean=m;}
  double mean() {return _mean;}
  void setStddev(double s) {_inv_stddev=1.0/s;}
  double stddev() {return 1.0/_inv_stddev;}
  bool isValid() {return _inv_stddev!=0;}
 protected:
  /// Calculate the prob integral between -infinity and z by Taylor serie
  double _calcErrorFunction(double z);
  double _mean;
  double _inv_stddev;
  /// internal precision limit for Taylor serie
  double _precision;
};

} // namespace QGpCoreTools

#endif // GAUSSDISTRIBUTION_H
