/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-07-05
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GLOBAL_H
#define GLOBAL_H

#include <QtCore>

namespace QGpCoreTools {

  // Redefine my own assert (assert even if QT_NO_DEBUG is defined)
  #if !defined(ASSERT)
  #ifndef NO_ASSERT
  #  define ASSERT(cond) do {if(!(cond))qt_assert(#cond,__FILE__,__LINE__);} while (0)
  #else
  #  define ASSERT(cond)
  #endif
  #endif

  // With gcc 4.1.2, I have a lot of unecessary warnings with -Wuninitialized
  // Maybe gcc will do a better job in the future
  #define SAFE_UNINITIALIZED(var,value) var=value;

  #define MAX_INT ((int)((uint)(-1)>>1))
  #define MAX_INT32 ((qint32)((quint32)(-1)>>1))

  // Usefull for compatibility with old names of properties in XML files
  #define DUMMY_PROPERTIES \
  public: \
    void setDummyProperty(const QString&) {} \
    void setDummyProperty(double) {} \
    void setDummyProperty(int) {} \
    QString dummyPropertyString() const {return QString::null;} \
    double dummyPropertyDouble() const {return 0.0;} \
    int dummyPropertyInt() const {return 0;}

  template<typename T> void unique(QList<T>& list)
  {
    qSort(list.begin(), list.end());
    for(int i=1; i<list.count(); ) {
      if(list.at(i-1)==list.at(i))
        list.removeAt(i);
      else
        i++;
    }
  }

  template<typename T> void unique(QVector<T>& v)
  {
    qSort(v.begin(), v.end());
    for(int i=1; i<v.count(); ) {
      if(v.at(i-1)==v.at(i))
        v.remove(i);
      else
        i++;
    }
  }

} // namespace QGpCoreTools

#endif // GLOBAL_H
