/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-08-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GridSearch_H
#define GridSearch_H

#include "Point2D.h"
#include "Function2Search.h"

namespace QGpCoreTools {

class GridFunction2;

class QGPCORETOOLS_EXPORT GridSearch : public Function2Search
{
public:
  GridSearch();
  ~GridSearch();

  void setGrid(double minX, double maxX, double dX,
               double minY, double maxY, double dY);

  int nx() const {return _nx;}
  int ny() const {return _ny;}
  double x(int i) const {return _x[i];}
  double y(int i) const {return _y[i];}

  double globalMax();
  Function2MaximaIterator localMax(int nMax, double absThres=0.0, double relThres=0.0);
  void setRelativePrecision(double p) {_precisionX=p;_precisionY=p; _relative = true; }
  void setAbsolutePrecision(double p) {_precisionX=p;_precisionY=p; _relative = false; }
protected:
  int _nx, _ny;
  double * _x, * _y;
  double _precisionX, _precisionY;
private:
  // For 2D grids
  double refineMax(double minX, double maxX, double minY, double maxY);
  inline void checkForMax(double x, double y, double& maxVal, double& maxX, double& maxY);
  // For 1D grids
  double refineMax(double minX, double maxX);
  inline void checkForMax(double x, double& maxVal, double& maxX);
};

} // namespace QGpCoreTools

#endif // GRIDSEARCH_H
