/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef INCREASESTORAGE_H
#define INCREASESTORAGE_H

#include <stdlib.h>

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT IncreaseStorage
{
public:
  inline IncreaseStorage(int defaultCapacity);
  inline IncreaseStorage(const IncreaseStorage& o);
  virtual ~IncreaseStorage() {}

  inline void reserve(int n);
  int size() const {return _size;}
  inline void add(int n=1);
  inline void clear();
  void downSize(int s) {_size=s;}
protected:
  virtual void reallocate() = 0;
  inline void * allocateVector(int itemSize);
  inline void * reallocateVector(void * vect, int itemSize);
private:
  int _defaultCapacity;
  int _capacity;
  volatile int _size;
};

inline IncreaseStorage::IncreaseStorage(int defaultCapacity)
{
  _defaultCapacity = defaultCapacity;
  clear();
}

inline IncreaseStorage::IncreaseStorage(const IncreaseStorage& o)
{
  _defaultCapacity = o._defaultCapacity;
  _capacity = o._capacity;
  _size = o._size;
}

inline void * IncreaseStorage::allocateVector(int itemSize)
{
  return malloc(_capacity * itemSize);
}

inline void * IncreaseStorage::reallocateVector(void * vect, int itemSize)
{
  return realloc(vect, _capacity * itemSize);
}

inline void IncreaseStorage::reserve(int n)
{
  if(_size+n >= _capacity) {
    while(_size+n >= _capacity) {
      _capacity=_capacity << 1;
    }
    reallocate();
  }
}

inline void IncreaseStorage::add(int n)
{
  _size+=n;
  if(_size>=_capacity) {
    do {
      _capacity=_capacity << 1;
    } while( _size>=_capacity);
    reallocate();
  }
}

inline void IncreaseStorage::clear()
{
  _capacity=_defaultCapacity;
  _size=0;
}

} // namespace QGpCoreTools

#endif // INCREASESTORAGE_H
