/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-25
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMEDPOINT_H
#define NAMEDPOINT_H

#include "Point.h"
#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT NamedPoint : public Point
{
public:
  NamedPoint() : Point() {}
  NamedPoint(double x, double y, double z=0.0, const QString& name=QString::null) : Point(x, y, z) {_name=name;}
  NamedPoint(const NamedPoint& p) : Point(p) {_name=p._name;}
  NamedPoint(const QString& name, const Point& p) : Point(p) {_name=name;}
  NamedPoint(const Point& p) : Point(p) {}
  NamedPoint(const Point2D& p) : Point(p) {}

  inline NamedPoint& operator=(const Point& p);
  inline NamedPoint& operator=(const Point2D& p);
  inline NamedPoint& operator=(const NamedPoint& p);

  inline NamedPoint operator+(const Point& p) const;
  inline NamedPoint operator-(const Point& p) const;
  inline NamedPoint operator*(double mul) const;
  inline NamedPoint operator*(const Point& p) const;
  inline NamedPoint operator/(double div) const;
  inline NamedPoint operator/(const Point& p) const;

  const QString& name() const { return _name; }
  void setName( QString n ) { _name = n; }

  void setCoordinates( const Point& p ) { *this = p; }
  const Point& coordinates() const { return *this; }

  bool fromString(StringSection str);
  QString toString(int precision=6) const;
private:
  QString _name;
};

inline NamedPoint& NamedPoint::operator=(const Point& p)
{
  TRACE;
  Point::operator=(p);
  return *this;
}

inline NamedPoint& NamedPoint::operator=(const Point2D& p)
{
  TRACE;
  Point::operator=(p);
  return *this;
}

inline NamedPoint& NamedPoint::operator=(const NamedPoint& p)
{
  TRACE;
  Point::operator=(p);
  _name = p._name;
  return *this;
}

inline NamedPoint NamedPoint::operator+(const Point& p) const
{
  return NamedPoint(x()+p.x(), y()+p.y(), z()+p.z(), _name);
}

inline NamedPoint NamedPoint::operator-(const Point& p) const
{
  return NamedPoint(x()-p.x(), y()-p.y(), z()-p.z(), _name);
}

inline NamedPoint NamedPoint::operator*(double mul) const
{
  return NamedPoint(x()*mul, y()*mul, z()*mul, _name);
}

inline NamedPoint NamedPoint::operator*(const Point& p) const
{
  return NamedPoint(x()*p.x(), y()*p.y(), z()*p.z(), _name);
}

inline NamedPoint NamedPoint::operator/(double div) const
{
  return NamedPoint(x()/div, y()/div, z()/div, _name);
}

inline NamedPoint NamedPoint::operator/(const Point& p) const
{
  return NamedPoint (x()/p.x(), y()/p.y(), z()/p.z(), _name);
}

} // namespace QGpCoreTools

#endif // NAMEDPOINT_H
