/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef POINT1D_H
#define POINT1D_H

#include "QGpCoreToolsDLLExport.h"
#include "StringSection.h"
#include "Trace.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT Point1D
{
public:
  Point1D() {_x=0.0;}
  Point1D(double x) {_x=x;}

  bool operator<(const Point1D& p) const {return _x<p._x;}
  bool operator==(const Point1D& p) const {return _x==p._x;}

  double x() const {return _x;}
  void setX(double x) {_x=x;}
  double y() const {return 0.0;}
  void setY(double) {}

  void setValid(bool) {}
  bool isValid() const {return true;}

  inline void interpole(double valX, const Point1D&, const Point1D&);
  void average(const Point1D&) {}

  // I/O functions
  bool fromString(const StringSection& str);
  QString toString(int precision=6) const;
private:
  double _x;
};

inline void Point1D::interpole(double valX, const Point1D&, const Point1D&)
{
  TRACE;
  setX(valX);
}

} // namespace QGpCoreTools

#endif // POINT1D.H
