/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-10-14
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ProcessStatistics_H
#define ProcessStatistics_H

#include <math.h>

#include "StatValue.h"
#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT ProcessStatistics
{
 public:
  ProcessStatistics() { clear(); }

  void add(double newval);
  void current(double& mean, double& stddev);
  double mean() {return _sumxi/_count;}
  double stddev();
  StatValue value();

  void addLog(double newval);
  void currentLog(double& mean, double& stddev);
  double meanLog() { return pow( 10.0, _sumxi/_count); }
  double stddevLog();
  StatValue valueLog();

  void clear() { _sumxi = 0.0; _sumxi2 = 0.0; _count=0; }
  int count() {return _count;}
 protected:
  double _sumxi;
  double _sumxi2;
  int _count;
};

} // namespace QGpCoreTools

#endif // PROCESSSTATISTICS_H
