/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-10-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RANDOM_H
#define RANDOM_H

#include <math.h>

#include "GaussDistribution.h"
#include "Translations.h"
#include "Trace.h"

namespace QGpCoreTools {

#define NTAB 32

class QGPCORETOOLS_EXPORT Random
{
    TRANSLATIONS("Random")
public:
  Random( int seed );
  Random( const QByteArray& s );

  inline int uniform( int min, int max );
  inline double uniform( double min, double max );
  double normal(double mean, double stddev);
  double normal(GaussDistribution & gd) {return normal(gd.mean(),gd.stddev());}
  double ran2();

  QByteArray state() const;
  static int stateSize() { return 35*sizeof(qint64); }

  void testPeriod();
  void testDistribution( double max, qint64 nReset );
private:
  //int _nCalls;
  qint64 _idum;
  qint64 _idum2;
  qint64 _iy;
  qint64 _iv[NTAB];
};

inline double Random::uniform( double min, double max )
{
  return min+(max-min)*ran2();
}

inline int Random::uniform( int min, int max )
{
  return min+(int)round( (max-min)*ran2() );
}

} // namespace QGpCoreTools

#endif // RANDOM_H
