/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-03-04
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLING_H
#define SAMPLING_H


#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT Sampling
{
public:
  Sampling();

  void operator=( const Sampling& o );

  enum Type {Linear,Log};

  void setType(Type t) {_type=t; setStep(); }
  Type type() const { return _type; }

  void setRange( double min, double max ) { _min= min; _max=max; setStep(); }
  double min() const { return _min; }
  double max() const { return _max; }

  void setCount( int n ) { _n = n; setStep(); }
  int count() const { return _n; }

  double value(int i) const;
  void inverse();
private:
  void setStep();

  double _min, _max, _step;
  int _n;
  Type _type;
};

} // namespace QGpCoreTools

#endif // SAMPLING_H
