/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-05-28
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef Segment2D_H
#define Segment2D_H

#include "QGpCoreToolsDLLExport.h"
#include "Point2D.h"
#include "Rect.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT Segment2D
{
public:
  Segment2D() {}
  Segment2D(Point2D& p1, Point2D& p2) {set(p1,p2);}
  Segment2D(double x1, double y1, double x2, double y2) {set(x1, y1, x2, y2);}

  bool intersect(const Segment2D& seg, Point2D& p) const;
  double distanceTo(Point2D& p) const;
  Point2D p1() const {return _p1;}
  Point2D p2() const {return _p2;}
  void set(const Point2D& p1, const Point2D& p2);
  void set(double x1, double y1, double x2, double y2);
  bool includes(Point2D& p) const;
  double length() const {return _p1.distanceTo(_p2);}
protected:
  Point2D _p1,_p2;
  Rect _limits;
};

} // namespace QGpCoreTools

#endif // SEGMENT2D.H
