/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-10-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONARITY_H
#define STATIONARITY_H

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT Stationarity
{
 public:
  Stationarity(int queueLength,double ratio=0.001);
  ~Stationarity();

  void add(double newval);
  bool relativeAtEnd();
  bool absoluteAtEnd();
  int nextIndex() {if(_currentI==_queueLength-1) _currentI=-1; return ++_currentI;}
  int oldestIndex() {if(_currentI==_queueLength-1) return 0; return _currentI+1;}
  double mean() {return _mean;}
  double maxErr() {return _maxdelta;}
  double count() {return _count;}
private:
  int _queueLength;
  double _mean;
  int _currentI;
  double * _values;
  int _count;
  int _imax;
  double _maxdelta;
  double _ratio;
};

} // namespace QGpCoreTools

#endif // STATIONARITY_H
