/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-11-24
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TREEITEM_H
#define TREEITEM_H

#include "XMLClass.h"
#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT TreeItem : public XMLClass
{
public:
  TreeItem( TreeItem * parent=0 );
  ~TreeItem();

  virtual const QString& xml_tagName() const { return xmlTreeItemTag; }
  static const QString xmlTreeItemTag;

  TreeItem * parent() const { return _parent; }
  void setParent( TreeItem * parent );

  bool isFolder() const { return _folder; }
  void setFolder() { _folder=true; }

  bool isModified() const;
  void setModified( bool m );

  void setRemoved( bool r );
  bool isRemoved() const { return _removed; }
  bool isParentRemoved() const;
  void removeChild( int index );
  void removeChildren();
  QList<TreeItem *> takeChildren();

  int childCount() const { return _children.count(); }
  int folderCount() const;

  int indexOfChild( TreeItem * item ) const { return _children.indexOf(item); }
  int indexOfFolder( TreeItem * g ) const;

  TreeItem * childAt( int index ) const { return _children.at(index); }
  TreeItem * folderAt( int index );

  int childRow();
  int folderRow();

  typedef QList<TreeItem *>::iterator iterator;
  typedef QList<TreeItem *>::const_iterator const_iterator;
  iterator begin() { return _children.begin(); }
  iterator end() { return _children.end(); }
  const_iterator begin() const { return _children.begin(); }
  const_iterator end() const { return _children.end(); }
protected:
  virtual TreeItem * createNewItem( TreeItem * parent )=0 ;

  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual void xml_polish(XML_POLISH_ARGS);
private:
  void addChild( TreeItem * item ) { _children.append(item); _modified=true; }

  TreeItem * _parent;
  QList<TreeItem *> _children;
  uint _modified:1;
  uint _folder:1;
  uint _removed:1;
  uint _unused:29;
};

} // namespace QGpCoreTools

#endif // TREEITEM_H
