/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-09-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VALUE_H
#define VALUE_H

#include <math.h>

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT Value
{
public:
  Value() { _valid = false; }
  Value( double val ) { _valid = true; _value = val; }
  Value( const Value& o ) { _valid = o._valid; _value = o._value; }
  ~Value() {}

  void operator=( const Value& o ) { _valid = o._valid; _value = o._value; }
  void operator=( double val ) { _valid = true; _value = val; }

  double value() const { return _value;}
  void setValue( double val ) { _value = val; _valid = true; }

  void setValid( bool v ) { _valid = v; }
  bool isValid() const { return _valid; }

  inline void log10();
  inline void exp10();
  inline void abs();
private:
  double _value;
  bool _valid;
};

inline void Value::log10()
{
  _value = ::log10( _value );
}

inline void Value::exp10()
{
  _value = ::pow( 10.0, _value );
}

inline void Value::abs()
{
  _value = ::fabs(_value);
}

} // namespace QGpCoreTools

#endif // VALUE_H
