/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-11-27
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLCLASSFACTORY_H
#define XMLCLASSFACTORY_H

#include <QtCore>

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class XMLClass;
class XMLClassCreator;
class XMLClassWorkshop;

class QGPCORETOOLS_EXPORT XMLClassFactory
{
public:
  ~XMLClassFactory();

  static XMLClassFactory * instance() { return & _self; }

  XMLClass * create( QString workshop, QString tag ) const;
  XMLClassCreator * creator( QString workshop, QString tag ) const;
  QStringList registeredTags( QString workshop ) const;

  void registerClass( QString workshop, QString tag, XMLClassCreator * creator );
  void registerSynonym( QString workshop, QString syn, QString tag );
protected:
  static XMLClassFactory _self;
private:
  XMLClassWorkshop * workshop( QString workshop );
  XMLClassWorkshop * workshop( QString workshop ) const;

  QMap<QString, XMLClassWorkshop *> _workshops;
};

class QGPCORETOOLS_EXPORT XMLClassWorkshop
{
public:
  XMLClassCreator * creator( QString tag ) const;
  QStringList registeredTags() const;
  void registerClass( QString tag, XMLClassCreator * creator );
  void registerSynonym( QString syn, QString tag );
private:
  QMap<QString, XMLClassCreator *> _registeredClasses;
  QMap<QString, QString> _registeredSynonyms;
};

class QGPCORETOOLS_EXPORT XMLClassCreator
{
public:
  XMLClassCreator( QString workshop, QString tag ) {
    XMLClassFactory::instance()->registerClass( workshop, tag, this );
  }
  virtual ~XMLClassCreator() {}
  virtual QString tagName() const = 0;
private:
  friend class XMLClassFactory;
  virtual XMLClass * create() const = 0;
};

#define XMLREGISTER_HEAD( _workshop_, _creator_, _className_, _tagName_ ) \
  class _className_##XMLClassCreator : public _creator_ \
  { \
  public: \
    _className_##XMLClassCreator() \
      : _creator_( _workshop_, _tagName_ ) {} \
    virtual QString tagName() const { return _tagName_; }

#define XMLREGISTER_TAIL( _className_ ) \
  private: \
    virtual XMLClass * create() const { return new _className_; } \
  }; \
  _className_##XMLClassCreator register##_className_;

#define XMLSYNONYM( _workshop_, _synName_, _tagName_ ) \
  class _synName_##XMLClassSynonym \
  { \
  public: \
    _synName_##XMLClassSynonym() { \
      XMLClassFactory::instance()->registerSynonym( _workshop_, # _synName_, _tagName_ ); \
    } \
  }; \
  _synName_##XMLClassSynonym register##_synName_;


} // namespace QGpCoreTools

#endif // XMLCLASSFACTORY_H
