/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-25
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLGENERICITEM_H
#define XMLGENERICITEM_H

#include "TreeItem.h"
#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

class QGPCORETOOLS_EXPORT XMLGenericItem : public TreeItem
{
public:
  XMLGenericItem( XMLGenericItem * parent = 0 );
  XMLGenericItem( QString tag, XMLGenericItem * parent = 0 );

  inline XMLGenericItem * childAt( int index ) const;
  inline XMLGenericItem * parent() const;

  QVariant value() const { return _value; }
  void setValue(QVariant v) { _value = v; }

  void setTag( QString tag ) { _tag = tag; }
  virtual const QString& xml_tagName() const { return _tag;}

  virtual void xml_attributes( XML_ATTRIBUTES_ARGS ) const { Q_UNUSED(context); attributes = _attributes; }
  virtual bool xml_setAttributes( XML_SETATTRIBUTES_ARGS );
  void addAttribute( const QString& key, const QString& value = QString::null ) { _attributes.add(key, value); }

  QList<XMLGenericItem *> children( QString tag ) const;
  void find( QList<XMLGenericItem *>& itemList, const XMLGenericItem * queryItem ) const;
protected:
  virtual TreeItem * createNewItem( TreeItem * ) { return 0; }
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual bool xml_setBinaryData( XML_SETBINARYDATA_ARGS );
private:
  QString _tag;
  XMLSaveAttributes _attributes;
  QVariant _value;
};

inline XMLGenericItem * XMLGenericItem::childAt( int index ) const
{
  TRACE;
  return static_cast<XMLGenericItem *>(TreeItem::childAt(index));
}

inline XMLGenericItem * XMLGenericItem::parent() const
{
  TRACE;
  return static_cast<XMLGenericItem *>(TreeItem::parent());
}

} // namespace QGpCoreTools

#endif // XMLGENERICITEM_H
