/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-10-03
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPTICITYFACTORY_H
#define ELLIPTICITYFACTORY_H

#include "DispersionFactory.h"
#include "Ellipticity.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT EllipticityFactory : public ModalFactory
{
  TRANSLATIONS("EllipticityFactory");
public:
  EllipticityFactory();
  ~EllipticityFactory();

  Ellipticity * values() { return _values; }

  double peakMisfit( const StatValue& val, DispersionFactory& disp, const LayeredModel * model );

  virtual void setMode ( const Mode& m );
  virtual const Value * mode( const Mode& m ) const;
  virtual int storageCount() const { return 1; }
  inline virtual ModalStorage * storage( int ) const;

  void log10() { _values->log10(); }
  void exp10() { _values->exp10(); }
protected:
  virtual ModalStorage * newStorage( int nModes ) { return new Ellipticity( nModes, x() ); }
private:
  Ellipticity * _values;
};

inline ModalStorage * EllipticityFactory::storage( int ) const
{
  TRACE;
  return _values;
}

} // namespace QGpCoreWave

#endif // ELLIPTICITYFACTORY_H
