/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-13
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAYEREDMODELEXPRESSIONCONTEXT_H
#define LAYEREDMODELEXPRESSIONCONTEXT_H

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class LayeredModel;

class QGPCOREWAVE_EXPORT LayeredModelExpressionContext : public ExpressionContext
{
public:
  LayeredModelExpressionContext();

  void setModel( LayeredModel * m ) { _model = m; }
  LayeredModel * model() const { return _model; }

  virtual QStringList functions() const;
  virtual bool isValidFunction(const QString& name) const;
  virtual QVariant functionValue(const QString& name, const QVector<ExpressionAction *>& args) const;
private:
  LayeredModel * _model;
};

class QGPCOREWAVE_EXPORT LayeredModelExpressionN : public ExpressionStorage
{
public:
  LayeredModelExpressionN( LayeredModelExpressionContext * context ) { _context = context; }

  virtual bool isReadOnly() const { return true; }
  virtual QVariant value(int) const;
  virtual void setValue(int, const QVariant& ) {}
private:
  LayeredModelExpressionContext * _context;
};

class QGPCOREWAVE_EXPORT LayeredModelExpressionH : public ExpressionStorage
{
public:
  LayeredModelExpressionH( LayeredModelExpressionContext * context ) { _context = context; }

  virtual bool isReadOnly() const { return false; }
  virtual QVariant value(int index) const;
  virtual void setValue(int, const QVariant& );
private:
  LayeredModelExpressionContext * _context;
};

class QGPCOREWAVE_EXPORT LayeredModelExpressionVp : public ExpressionStorage
{
public:
  LayeredModelExpressionVp( LayeredModelExpressionContext * context ) { _context = context; }

  virtual bool isReadOnly() const { return false; }
  virtual QVariant value(int index) const;
  virtual void setValue(int, const QVariant& );
private:
  LayeredModelExpressionContext * _context;
};

class QGPCOREWAVE_EXPORT LayeredModelExpressionVs : public ExpressionStorage
{
public:
  LayeredModelExpressionVs( LayeredModelExpressionContext * context ) { _context = context; }

  virtual bool isReadOnly() const { return false; }
  virtual QVariant value(int index) const;
  virtual void setValue(int, const QVariant& );
private:
  LayeredModelExpressionContext * _context;
};

class QGPCOREWAVE_EXPORT LayeredModelExpressionRho : public ExpressionStorage
{
public:
  LayeredModelExpressionRho( LayeredModelExpressionContext * context ) { _context = context; }

  virtual bool isReadOnly() const { return false; }
  virtual QVariant value(int index) const;
  virtual void setValue(int, const QVariant& );
private:
  LayeredModelExpressionContext * _context;
};

} // namespace QGpCoreWave

#endif // LAYEREDMODELEXPRESSIONCONTEXT_H
