/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-04-28
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LOVE_H
#define LOVE_H

#include "QGpCoreWaveDLLExport.h"
#include "LayeredModel.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT Love
{
public:
  Love( const LayeredModel * model ) { _model = model; }

  const LayeredModel * model() const { return _model; }

  void setOmega(double o) { _omega=o; }
  double ellipticity() {return 0;}

  double y(double slowness);
private:
  const LayeredModel * _model;
  double _omega;
};

} // namespace QGpCoreWave

#endif // LOVE_H
