/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-17
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LOVEFUNCTION_H
#define LOVEFUNCTION_H

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class LayeredModel;

class QGPCOREWAVE_EXPORT LoveFunction : public AbstractFunction2
{
public:
  LoveFunction();
  ~LoveFunction();

  void setModel( const LayeredModel * m ) { _model = m; }

  virtual double value(double x, double y) const;
private:
  const LayeredModel * _model;
};

} // namespace QGpCoreWave

#endif // LOVEFUNCTION_H
