/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-09-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALCURVE_H
#define MODALCURVE_H

#include <QGpCoreTools.h>
#include "Mode.h"
#include "FactoryPoint.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class ModalFactory;

class QGPCOREWAVE_EXPORT ModalCurve : public Curve<FactoryPoint>, public XMLClass
{
  TRANSLATIONS("ModalCurve");
public:
  ModalCurve() {}
  inline ModalCurve( const ModalCurve& o );
  ModalCurve( int n ) : Curve<FactoryPoint>(n) {}
  inline ModalCurve( const Curve<StatPoint>& o );
  virtual ~ModalCurve();

  inline bool operator==( const ModalCurve& o) const;
  void operator=( const Curve<StatPoint>& o);

  virtual const QString& xml_tagName() const { return xmlModalCurveTag;}
  static const QString xmlModalCurveTag;

  void clear();
  void sort() { setFunction(); }

  void addMode( const Mode& m );
  void removeMode( int index );
  void linkX( const QVector<double>& x );
  const QList<Mode>& modes() const { return _modes; }
  QList<Mode>& modes() { return _modes; }
  bool hasMode( const Mode& m ) const;
  int indexOf( int factoryIndex ) const;

  void setName( QString n ) { _name = n; }
  QString name() const { return _name; }

  void addLog( QString s ) { _log+=s; }
  QString log() const { return _log; }

  double misfit( int& nValues, int& nData, const ModalFactory& f, StatValue::MisfitType type, double minMisfit ) const;
protected:
  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _name;
  QList<Mode> _modes;
  QString _log;
};

inline ModalCurve::ModalCurve( const ModalCurve& o ) : Curve<FactoryPoint>(o), XMLClass()
{
  TRACE;
  _name = o._name;
  _modes = o._modes;
  _log = o._log;
}

inline ModalCurve::ModalCurve( const Curve<StatPoint>& o ) : Curve<FactoryPoint>(), XMLClass()
{
  TRACE;
  *this = o;
}

inline bool ModalCurve::operator==( const ModalCurve& o) const
{
  return _name == o._name &&
         _modes == o._modes &&
         _log == o._log &&
         Curve<FactoryPoint>::operator==(o);
}

} // namespace QGpCoreWave

#endif // MODALCURVE_H
