/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-10-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALREFINE_H
#define MODALREFINE_H

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT ModalRefine
{
public:
  ModalRefine() { _nModes = 0; _values = 0; }
  inline ModalRefine( int nModes, double x );
  inline ModalRefine( const ModalRefine& o );
  ~ModalRefine() { delete [] _values; }

  inline void operator=( const ModalRefine& o );
  bool operator<( const ModalRefine& o ) const { return _x < o._x; }

  double x() const { return _x;}

  const Value& value( int iMode ) const { ASSERT(iMode<_nModes); return _values[ iMode ];}
  void setValue( int iMode, double val ) { ASSERT(iMode<_nModes); _values[ iMode ].setValue( val ); }
  void setValid( int iMode, bool v ) { ASSERT(iMode<_nModes); _values[ iMode ].setValid( v ); }
  inline void setValid( bool v );
private:
  double _x;
  int _nModes;
  Value * _values;
};

typedef QList<ModalRefine> RefineList;
typedef QList<ModalRefine>::ConstIterator RefineIterator;

inline ModalRefine::ModalRefine( int nModes, double x )
{
  TRACE;
  _nModes = nModes;
  _values = new Value [ _nModes ];
  _x = x;
}

inline ModalRefine::ModalRefine( const ModalRefine& o )
{
  TRACE;
  _x = o._x;
  _nModes = o._nModes;
  _values = new Value [ _nModes ];
  for (int i=0;i<_nModes;i++) {
    _values[i]=o._values[i];
  }
}

inline void ModalRefine::operator=( const ModalRefine& o )
{
  TRACE;
  _x = o._x;
  _nModes = o._nModes;
  delete [] _values;
  _values = new Value [ _nModes ];
  for (int i=0;i<_nModes;i++) {
    _values[i]=o._values[i];
  }
}

inline void ModalRefine::setValid( bool v )
{
  TRACE;
  for (int i=0;i<_nModes;i++) {
    _values[i].setValid(v);
  }
}

} // namespace QGpCoreWave

#endif // MODALREFINE_H
