/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-02
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONCURVE_H
#define REFRACTIONCURVE_H

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"
#include "FactoryPoint.h"

namespace QGpCoreWave {

class RefractionFactory;

class QGPCOREWAVE_EXPORT RefractionCurve : public Curve<FactoryPoint>, public XMLClass
{
public:
  RefractionCurve() { _source = 0.0; }
  inline RefractionCurve( const RefractionCurve& o );
  RefractionCurve( int n ) : Curve<FactoryPoint>(n) { _source = 0.0; }
  virtual ~RefractionCurve() {}

  inline bool operator==( const RefractionCurve& o) const;

  virtual const QString& xml_tagName() const { return xmlRefractionCurveTag;}
  static const QString xmlRefractionCurveTag;

  void clear();
  void sort() { setFunction(); }

  void setName( QString n ) { _name = n; }
  QString name() const { return _name; }

  void addLog( QString s ) { _log+=s; }
  QString log() const { return _log; }

  void setSource( double s ) { _source = s; }
  double source() const { return _source; }

  void linkSource( const QVector<double>& xSrc );
  void linkReceivers( const QVector<double>& xRec );

  double misfit( int& nValues, int& nData, const RefractionFactory& f, StatValue::MisfitType type, double minMisfit ) const;
protected:
  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _name;
  QString _log;
  double _source;
  int _sourceIndex;
};

inline RefractionCurve::RefractionCurve( const RefractionCurve& o ) : Curve<FactoryPoint>(o), XMLClass()
{
  TRACE;
  _name = o._name;
  _log = o._log;
  _source = o._source;
}

inline bool RefractionCurve::operator==( const RefractionCurve& o) const
{
  return _name == o._name &&
         _log == o._log &&
         _source == o._source &&
         Curve<FactoryPoint>::operator==(o);
}

} // namespace QGpCoreWave

#endif // REFRACTIONCURVE_H
