/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONFACTORY_H
#define REFRACTIONFACTORY_H

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class TiltLayeredModel;
class RefractionCurve;

class QGPCOREWAVE_EXPORT RefractionFactory
{
  TRANSLATIONS("RefractionFactory");
public:
  RefractionFactory();
  ~RefractionFactory();

  int sourceCount() const { return _sources.count(); }
  int receiverCount() const { return _receivers.count(); }
  const QVector<double>& sources() const { return _sources; }
  const QVector<double>& receivers() const { return _receivers; }
  const Value * source( int index ) const { return _travelTimes + index * _receivers.count(); }

  void setX( const QList<RefractionCurve>& curves );
  void linkX( QList<RefractionCurve>& curves ) const;
  double xLeft() const { return _receivers.first(); }
  double xRight() const { return _receivers.last(); }

  bool calculate( TiltLayeredModel * model );

  void writeReport( QDataStream& s ) const;
  void readReport( QDataStream& s );
  void toStream( int sourceIndex, QTextStream& sOut ) const;
private:
  QVector<double> _sources;
  QVector<double> _receivers;
  Value * _travelTimes;
};

inline uint qHash( const double& key )
{
  return qHash( static_cast<const quint64&>( key ) );
}

} // namespace QGpCoreWave

#endif // REFRACTIONFACTORY_H
