/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-10-15
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SHAMPLIFICATION_H
#define SHAMPLIFICATION_H

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class LayeredModel;

class QGPCOREWAVE_EXPORT ShAmplification
{
public:
  ShAmplification( const LayeredModel * model ) { _model = model; }

  Curve<Point2D> curve( int fcount, double fmax, float theta );
private:
  const LayeredModel * _model;
};

} // namespace QGpCoreWave

#endif // SHAMPLIFICATION_H
