/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef THEORETICALFK_H
#define THEORETICALFK_H

#include <math.h>

#include <QGpCoreTools.h>
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT TheoreticalFK : public AbstractFunction2
{
public:
  TheoreticalFK(const QVector<Point2D>& stations);

  inline virtual double value(double kx, double ky) const;
  const QVector<Point2D>& stations() const {return _stations;}
private:
  QVector<Point2D> _stations;
  double _fac;
};

inline double TheoreticalFK::value(double kx, double ky) const
{
  TRACE;
  double csum=0.0, ssum=0.0, val;
  for (int i=_stations.count()-1; i>=0; i--) {
    const Point2D& s=_stations[i];
    val=kx*s.x()+ky*s.y();
    csum+=cos(val);
    ssum+=sin(val);
  }
  return (csum*csum+ssum*ssum)*_fac;
}

} // namespace QGpCoreWave

#endif // THEORETICALFK_H
