/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-08
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <QtGui>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT Application : public CoreApplicationPrivate, public QApplication
{
  TRANSLATIONS("Application")
public:
  Application(int & argc, char ** argv, ApplicationHelp * ( *help ) (), bool reportBugs = true );
  ~Application();

  void setConsoleMessage();
  void setGuiMessage();
  static Application * instance() { return static_cast<Application *>(CoreApplicationPrivate::instance()); }
  virtual bool hasGui() const;
protected:
  virtual void setHelp( ApplicationHelp * h );
private:
  void reportBug();
  void reportInterrupt();
};

#ifdef app
#  undef app
#endif

#define qgpApp (*static_cast<Application *>(Application::instance()))

} // namespace QGpGuiTools

#endif // APPLICATION_H
