/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-07-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CAST_H
#define CAST_H

#include <QtGui>

namespace QGpGuiTools {

class Cast
{
public:
  template <typename T> static T getTab( QTabWidget * tab, QString tabName );
  template <typename TIn, typename TOut> static TOut getFirst( QList<TIn> list );
};

template <typename T> T Cast::getTab( QTabWidget * tab, QString tabName )
{
  T w = 0;
  for ( int i = tab->count() - 1; w == 0 && i >= 0 ;i-- ) {
    w = qobject_cast<T>( tab ->widget( i ) );
    if ( w && w->objectName() != tabName ) w = 0;
  }
  return w;
}

template <typename TIn, typename TOut> TOut Cast::getFirst( QList<TIn> list )
{
  typedef typename QList<TIn>::iterator ListIterator;
  ListIterator it;
  TOut obj;
  for ( it = list.begin();it != list.end();++it ) {
    obj = qobject_cast<TOut>( *it );
    if ( obj ) return obj;
  }
  return 0;
}

} // namespace QGpGuiTools

#endif // CAST_H
