/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-05-24
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTE_H
#define COLORPALETTE_H

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"
#include "ColorPaletteData.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ColorPalette : public XMLClass
{
  TRANSLATIONS( "ColorPalette" )
public:
  ColorPalette() { _d = new ColorPaletteData; }

  virtual const QString& xml_tagName() const { return xmlColorPaletteTag; }
  static const QString xmlColorPaletteTag;

  bool operator==(const ColorPalette& o) const { return _d->operator==(*o._d); }
  bool operator!=(const ColorPalette& o) const { return _d->operator!=(*o._d); }

  void allocate(int n=10) { _d->allocate(n); }
  void defaultColors(int n=10, int transparency=255) { defaultHSVColors(255, 255, n, transparency); }
  inline void defaultRGBColors(int n=10, int transparency=255);
  inline void defaultHSVColors(int sat, int value, int n=10, int transparency=255);
  inline void defaultBW(int n=10, int transparency=255);
  inline void colorRGBInterpole(int imin, int imax);
  inline void colorHSVInterpole(int imin, int imax);
  inline void setVLinear(double min, double max);
  inline void setVLog(double min, double max);
  inline void setVLinear(int imin, int imax, double min, double max);
  inline void setVLog(int imin, int imax, double min, double max);

  int count() const { return _d->count(); }

  void setUpperValue( int i, double v ) { _d->setUpperValue( i, v ); }
  double upperValue( int i ) const { return _d->upperValue( i ); }
  double lowerValue( int i ) const { return _d->lowerValue( i ); }

  const QColor& color( int i ) const { return _d->color( i ); }
  const QColor& color( double val ) const { return _d->color( val ); }
  void setColor( int i, const QColor& c ) const { return _d->setColor( i, c ); }

  int index(double val) const  { return _d->index(val); }
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QSharedDataPointer<ColorPaletteData> _d;
};

QGPGUITOOLS_EXPORT QTextStream& operator>>( QTextStream& s, ColorPalette& p );
QGPGUITOOLS_EXPORT QTextStream& operator<<( QTextStream& s, const ColorPalette& p );

inline void ColorPalette::defaultRGBColors( int n, int transparency )
{
  _d->defaultRGBColors(n, transparency);
}

inline void ColorPalette::defaultHSVColors( int sat, int value, int n, int transparency )
{
  _d->defaultHSVColors(sat, value, n, transparency);
}

inline void ColorPalette::defaultBW( int n, int transparency )
{
  _d->defaultBW( n, transparency );
}

inline void ColorPalette::colorRGBInterpole( int imin, int imax )
{
  _d->colorRGBInterpole( imin, imax);
}

inline void ColorPalette::colorHSVInterpole( int imin, int imax )
{
  _d->colorHSVInterpole( imin, imax);
}

inline void ColorPalette::setVLinear( double min, double max )
{
  _d->setVLinear( min, max);
}

inline void ColorPalette::setVLog( double min, double max )
{
  _d->setVLog( min, max);
}

inline void ColorPalette::setVLinear(int imin, int imax, double min, double max )
{
  _d->setVLinear( imin, imax, min, max);
}

inline void ColorPalette::setVLog(int imin, int imax, double min, double max)
{
  _d->setVLog( imin, imax, min, max);
}

} // namespace QGpGuiTools

// Allow passing ColorPalette as a QVariant
using namespace QGpGuiTools;
Q_DECLARE_METATYPE(ColorPalette);

#endif // COLORPALETTE_H
