/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-02
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTEDATA_H
#define COLORPALETTEDATA_H

#include <QtGui>
#include <QGpCoreTools.h>
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ColorPaletteData : public QSharedData
{
public:
  ColorPaletteData();
  ColorPaletteData( const ColorPaletteData& o );
  ~ColorPaletteData();

  bool operator==(const ColorPaletteData& o) const;
  bool operator!=(const ColorPaletteData& o) const { return ! operator==(o); }

  void allocate(int n);
  void defaultRGBColors(int n, int transparency);
  void defaultHSVColors(int sat, int value, int n, int transparency);
  void defaultBW(int n, int transparency);
  void colorRGBInterpole(int imin, int imax);
  void colorHSVInterpole(int imin, int imax);
  void setVLinear(double min, double max) { setVLinear(0, _n-2, min, max); }
  void setVLog(double min, double max) { setVLog(0, _n-2, min, max); }
  void setVLinear(int imin, int imax, double min, double max);
  void setVLog(int imin, int imax, double min, double max);

  int count() const { return _n; }

  void setUpperValue(int i, double v) { _upperValues[i]=v; }
  double upperValue(int i) const { return i<_n-1 ? _upperValues[i] : 1e99; }
  double lowerValue(int i) const { return i>0 ? _upperValues[i-1] : -1e99; }

  QColor& color(int i) const { return _colors[i]; }
  QColor& color(double val) const { return _colors[index(val)]; }
  void setColor( int i, const QColor& c ) const { _colors[i] = c; }

  int index(double val) const;
private:
  QColor * _colors;
  double * _upperValues;
  int _n;
  int _n2;
};

} // namespace QGpGuiTools

#endif // COLORPALETTEDATA_H
