/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLUMNTEXTWIDGET_H
#define COLUMNTEXTWIDGET_H

#include <QGpCoreTools.h>

#include "ui_ColumnTextWidget.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ColumnTextWidget : public QWidget, private Ui::ColumnTextWidget
{
  Q_OBJECT
public:
  ColumnTextWidget( QWidget * parent=0 );
  ~ColumnTextWidget();

  bool setFile(const QString& fileName);
  bool setBuffer(const QString& str);
  void setParserFile(const QString& p);
  void setStandardTypes(const QStringList& t);
  void setTypes(const QVector<int>& t);
  void parse();

  void restoreParserSettings(QString keyName);
  void saveParserSettings(QString keyName);

  const ColumnTextParser * parser() const {return _parser;}
  ColumnTextParser * parser() {return _parser;}
private slots:
  void on_parserName_editTextChanged(const QString& text);
  void on_linesBut_clicked();
  void on_columnsBut_clicked();
  void on_sectionsBut_clicked();
  void on_loadBut_clicked();
  void on_saveBut_clicked();
  void restoreColumnWidths();
private:
  QFile * _file;
  QString * _buffer;
  ColumnTextParser * _parser;
  QString _parserFile;
  QString _restoreColumnWidth;
};

} // namespace QGpGuiTools

#endif // COLUMNTEXTWIDGET_H
